/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Quick 3D.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

import QtQuick 2.15
import HelperWidgets 2.0
import QtQuick.Layouts 1.12

Column {
    width: parent.width

    Section {
        caption: qsTr("Distortion")
        width: parent.width

        SectionLayout {
            Label {
                text: qsTr("Radius")
                tooltip: qsTr("Radius of the effect.")
            }
            SecondColumnLayout {
                SpinBox {
                    maximumValue: 100
                    minimumValue: 0
                    decimals: 2
                    backendValue: backendValues.radius
                    Layout.fillWidth: true
                }
            }
            Label {
                text: qsTr("Width")
                tooltip: qsTr("Width of the distortion.")
            }
            SecondColumnLayout {
                SpinBox {
                    maximumValue: 100
                    minimumValue: 2
                    decimals: 2
                    backendValue: backendValues.distortionWidth
                    Layout.fillWidth: true
                }
            }
            Label {
                text: qsTr("Height")
                tooltip: qsTr("Height of the distortion.")
            }
            SecondColumnLayout {
                SpinBox {
                    maximumValue: 100
                    minimumValue: 0
                    decimals: 2
                    backendValue: backendValues.distortionHeight
                    Layout.fillWidth: true
                }
            }
            Label {
                text: qsTr("Phase")
                tooltip: qsTr("Phase of the distortion.")
            }
            SecondColumnLayout {
                SpinBox {
                    maximumValue: 360
                    minimumValue: 0
                    decimals: 0
                    backendValue: backendValues.distortionPhase
                    Layout.fillWidth: true
                }
            }
        }
    }

    Section {
        id: centerSection
        width: parent.width
        caption: qsTr("Position")

        property int labelWidth: 10
        property int labelSpinBoxSpacing: 0
        property int spinBoxMinimumWidth: 120

        ColumnLayout {
            width: parent.width - 16

            Label {
                width: 100
                text: qsTr("Center")
                tooltip: qsTr("Center of the distortion.")
            }
            RowLayout {
                spacing: centerSection.labelSpinBoxSpacing

                Label {
                    text: qsTr("X")
                    width: centerSection.labelWidth
                }
                SpinBox {
                    maximumValue: 1
                    minimumValue: 0
                    decimals: 2
                    stepSize: 0.1
                    backendValue: backendValues.center_x
                    Layout.fillWidth: true
                    Layout.minimumWidth: centerSection.spinBoxMinimumWidth
                }
            }
            RowLayout {
                spacing: centerSection.labelSpinBoxSpacing

                Label {
                    text: qsTr("Y")
                    width: centerSection.labelWidth
                }
                SpinBox {
                    maximumValue: 1
                    minimumValue: 0
                    decimals: 2
                    stepSize: 0.1
                    backendValue: backendValues.center_y
                    Layout.fillWidth: true
                    Layout.minimumWidth: centerSection.spinBoxMinimumWidth
                }
            }
        }
    }
}
